/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa;

import com.ibm.hwmca.base.pa.problem.FailingSystemProblemFilter;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.interfaces.ServiceDataProvider;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.pa.problem.ProblemFilter;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.ServiceHistoryDisplayProblemFilter;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.report.ReportListener;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfacesException;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.problem.ProblemBeanFactory;
import com.ibm.hwmca.xfw.panel.pa.svchist.ProblemSummaryBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.RepairInformationBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.ServiceHistorySummaryBeanReadOnly;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ServiceDataProviderImpl
implements ServiceDataProvider {
    private static final String TRACE_MASKT = "XSHSDPTT";
    private static final String TRACE_MASKF = "XSHSDPTF";
    private static final String TRACE_MASKD = "XSHSDPTD";
    private static final boolean UNIT_TEST = true;
    private HashMap _probUnidMap = new HashMap(32);

    public void getServiceHistorySummaryData(ObjectId[] targets, ReportListener listener) throws HException {
        Trace.trace(TRACE_MASKD, "--> getServiceHistroySummaryData(multi target)");
        this.getServiceHistorySummaryData(targets[0]);
        Trace.trace(TRACE_MASKD, "<-- getServiceHistroySummaryData(multi target)");
    }

    public ServiceHistorySummaryBeanReadOnly getServiceHistorySummaryData(ObjectId target) throws HException {
        ServiceHistorySummaryBeanReadOnly shsb = new ServiceHistorySummaryBeanReadOnly();
        Trace.trace(TRACE_MASKD, "--> getServiceHistroySummaryData - Tower (single target)");
        try {
            ProblemManager problemManager = ProblemManager.getProblemManager();
            Trace.trace(TRACE_MASKD, "Get the problems");
            ArrayList<ProblemFilter> filterList = new ArrayList<ProblemFilter>();
            filterList.add(new ServiceHistoryDisplayProblemFilter());
            filterList.add(new FailingSystemProblemFilter(target));
            List problemList = problemManager.filter(filterList);
            Trace.trace(TRACE_MASKD, "got " + problemList.size() + " problems to work with");
            Iterator problemIterator = problemList.iterator();
            boolean i = true;
            int probCounter = 0;
            String machineName = "";
            while (problemIterator.hasNext()) {
                CommonProblem myProb = (CommonProblem)problemIterator.next();
                if (myProb.getProblemOrigin().equals("LEGAGY_LOCAL")) {
                    BaseMessageText message = new BaseMessageText("XSH3005");
                    Trace.trace(TRACE_MASKD, "legacy problem ");
                    Trace.trace(TRACE_MASKD, "set message to be = " + message);
                    shsb.setReadOnly(true);
                    shsb.setReadMessage(message);
                }
                Trace.trace(TRACE_MASKD, "Add the service History data for problem " + Integer.toString(myProb.getProblemNumber()) + "\n");
                Trace.trace(TRACE_MASKD, myProb.formatProblemString(myProb.getProblemString()));
                machineName = myProb.getFailingSystem().getMOSystemName();
                if (machineName == null) {
                    machineName = "";
                }
                String probNumString = Integer.toString(myProb.getProblemNumber());
                this._probUnidMap.put(probNumString, myProb.getUniqueKey());
                shsb.addDataRow(new Date(myProb.getProblemTimeStamp()), machineName, probNumString, myProb.getServiceHistoryStateLT(), myProb.getDescription());
                Trace.trace(TRACE_MASKD, "count = " + probCounter);
                Trace.trace(TRACE_MASKD, "bean count = " + shsb.getServiceHistoryTableRowCount());
                ++probCounter;
            }
        }
        catch (Exception e) {
            throw new HException(e);
        }
        Trace.trace(TRACE_MASKD, "<-- getServiceHistroySummaryData (single target)");
        return shsb;
    }

    public ProblemSummaryBean getProblemSummaryBean(ObjectId objectId, String problem, String system) throws HException {
        Trace.trace(TRACE_MASKD, "-->getProblemSummaryBean for problem " + problem);
        try {
            ProblemManager problemManager = ProblemManager.getProblemManager();
            Trace.trace(TRACE_MASKD, "convert to an Int");
            String problemNumber = (String)this._probUnidMap.get(problem);
            Trace.trace(TRACE_MASKD, "get the problem");
            CommonProblem aProblem = (CommonProblem)problemManager.getProblem(problemNumber);
            if (aProblem != null) {
                Trace.trace(TRACE_MASKD, "got a problem to work with");
                Trace.trace(TRACE_MASKD, aProblem.formatProblemString(aProblem.getProblemString()));
            }
            ProblemSummaryBean psb = null;
            try {
                ProblemBeanFactory cbf = (ProblemBeanFactory)ServiceInterfaces.getFactory(aProblem, "BeanFactory");
                psb = cbf.getProblemSummaryBean(aProblem, objectId, system);
            }
            catch (ServiceInterfacesException e) {
                Trace.trace(TRACE_MASKT, "can't resolve bean factory!");
                Trace.trace(TRACE_MASKF, e);
                throw new HException(e);
            }
            Trace.trace(TRACE_MASKD, "<--getProblemSummaryBean");
            return psb;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Got PM Exception");
            Trace.trace(TRACE_MASKD, e);
            Trace.trace(TRACE_MASKD, "<--getProblemSummaryBean");
            return null;
        }
    }

    public RepairInformationBean getRepairInformationBean(ObjectId objectId, String problem, String system) throws HException {
        Trace.trace(TRACE_MASKD, "-->RepairInformationBean for problem" + problem);
        try {
            ProblemManager problemManager = ProblemManager.getProblemManager();
            Trace.trace(TRACE_MASKD, "convert to an Int");
            String problemNumber = (String)this._probUnidMap.get(problem);
            Trace.trace(TRACE_MASKD, "get the problem");
            CommonProblem aProblem = (CommonProblem)problemManager.getProblem(problemNumber);
            if (aProblem != null) {
                Trace.trace(TRACE_MASKD, "got a problem to work with");
                Trace.trace(TRACE_MASKD, aProblem.formatProblemString(aProblem.getProblemString()));
            }
            RepairInformationBean rib = null;
            try {
                ProblemBeanFactory cbf = (ProblemBeanFactory)ServiceInterfaces.getFactory(aProblem, "BeanFactory");
                rib = cbf.getRepairInformationBean(aProblem, objectId, system);
            }
            catch (ServiceInterfacesException e) {
                Trace.trace(TRACE_MASKT, "can't resolve bean factory!");
                Trace.trace(TRACE_MASKF, e);
                throw new HException(e);
            }
            Trace.trace(TRACE_MASKD, "<--RepairInformationBean");
            return rib;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Got PM Exception =" + e);
            Trace.trace(TRACE_MASKD, "<--RepairInformationBean");
            e.printStackTrace();
            return null;
        }
    }

    public void closeProblems(ReportListener listener, ObjectId objectId, List problems) {
        Trace.trace(TRACE_MASKD, "-->closeProblems");
        Trace.trace(TRACE_MASKD, "got " + problems.size() + " problems to close");
        Iterator problemIt = problems.iterator();
        try {
            while (problemIt.hasNext()) {
                String problemNumber = (String)problemIt.next();
                String uuid = (String)this._probUnidMap.get(problemNumber);
                Trace.trace(TRACE_MASKD, "go get problem " + problemNumber);
                CommonProblem problem = (CommonProblem)ProblemManager.getProblemManager().getProblem(uuid);
                if (problem instanceof CommonProblem) {
                    Trace.trace(TRACE_MASKD, "closing common problem " + problem.getProblemNumber());
                    problem.serviceHistoryClose();
                    continue;
                }
                Trace.trace(TRACE_MASKD, "closing problem " + problem.getProblemNumber());
                problem.addHistory(new HistoryEntry(33));
                ProblemManager.getProblemManager().close(problem);
            }
            Trace.trace(TRACE_MASKD, "send back the completion report");
            CompletionReport compReport = new CompletionReport();
            compReport.setCompletionCode(CompletionReportCode.SUCCESS);
            compReport.setObjectId(objectId);
            listener.completeReport(compReport);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
            CompletionReport compReport = new CompletionReport();
            compReport.setCompletionCode(CompletionReportCode.FAIL);
            compReport.setObjectId(objectId);
            listener.completeReport(compReport);
        }
        Trace.trace(TRACE_MASKD, "<--closeProblems");
    }

    public void closeAllProblems(ReportListener listener, ObjectId target, long startTime, long endTime) {
        Trace.trace(TRACE_MASKD, "-->closeAllProblems");
        Set problemSet = this._probUnidMap.keySet();
        ArrayList problemList = new ArrayList(20);
        Iterator iterator = problemSet.iterator();
        while (iterator.hasNext()) {
            problemList.add(iterator.next());
        }
        this.closeProblems(listener, target, problemList);
        Trace.trace(TRACE_MASKD, "<--closeAllProblems");
    }

    public PanelBean getProblemAnalysisBean(ObjectId objectId, String problem, String system) throws HException {
        Trace.trace(TRACE_MASKD, "-->getProblemAnalysisBean for problem " + problem);
        try {
            ProblemManager problemManager = ProblemManager.getProblemManager();
            Trace.trace(TRACE_MASKD, "convert to an Int");
            String problemNumber = (String)this._probUnidMap.get(problem);
            Trace.trace(TRACE_MASKD, "get the problem");
            CommonProblem aProblem = (CommonProblem)problemManager.getProblem(problemNumber);
            if (aProblem != null) {
                Trace.trace(TRACE_MASKD, "got a problem to work with");
                Trace.trace(TRACE_MASKD, aProblem.formatProblemString(aProblem.getProblemString()));
            }
            PanelBean pab = null;
            try {
                ProblemBeanFactory cbf = (ProblemBeanFactory)ServiceInterfaces.getFactory(aProblem, "BeanFactory");
                pab = cbf.getProblemAnalysisBean(aProblem, objectId, system, 3);
            }
            catch (ServiceInterfacesException e) {
                Trace.trace(TRACE_MASKT, "can't resolve bean factory!");
                Trace.trace(TRACE_MASKF, e);
                throw new HException(e);
            }
            Trace.trace(TRACE_MASKD, "<--getProblemAnalysisBean");
            return pab;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Got PM Exception =" + e);
            Trace.trace(TRACE_MASKD, "<--getProblemAnalysisBean");
            e.printStackTrace();
            return null;
        }
    }

    public PanelBean getServiceInformationBeanOperator(ObjectId objectId, String problem, String system) throws HException {
        Trace.trace(TRACE_MASKD, "-->getServiceInformationBean");
        try {
            ProblemManager problemManager = ProblemManager.getProblemManager();
            Trace.trace(TRACE_MASKD, "convert to an Int");
            String problemNumber = (String)this._probUnidMap.get(problem);
            Trace.trace(TRACE_MASKD, "get problem" + problemNumber);
            CommonProblem aProblem = (CommonProblem)problemManager.getProblem(problemNumber);
            if (aProblem != null) {
                Trace.trace(TRACE_MASKD, "got a problem to work with");
                Trace.trace(TRACE_MASKD, aProblem.formatProblemString(aProblem.getProblemString()));
            }
            PanelBean sib = null;
            try {
                ProblemBeanFactory cbf = (ProblemBeanFactory)ServiceInterfaces.getFactory(aProblem, "BeanFactory");
                sib = cbf.getServiceInformationBeanOperator(aProblem, objectId, system, 3);
            }
            catch (ServiceInterfacesException e) {
                Trace.trace(TRACE_MASKT, "can't resolve bean factory!");
                Trace.trace(TRACE_MASKF, e);
                throw new HException(e);
            }
            Trace.trace(TRACE_MASKD, "<--getServiceInformationBeanOperator");
            return sib;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Got PM Exception =" + e);
            Trace.trace(TRACE_MASKD, "<--getServiceInformationBeanOperator");
            e.printStackTrace();
            return null;
        }
    }

    public PanelBean getServiceInformationBeanCE(ObjectId objectId, String problem, String system) throws HException {
        Trace.trace(TRACE_MASKD, "-->getServiceInformationBeanCE");
        try {
            ProblemManager problemManager = ProblemManager.getProblemManager();
            Trace.trace(TRACE_MASKD, "convert to an Int");
            String problemNumber = (String)this._probUnidMap.get(problem);
            Trace.trace(TRACE_MASKD, "get the problem");
            CommonProblem aProblem = (CommonProblem)problemManager.getProblem(problemNumber);
            if (aProblem != null) {
                Trace.trace(TRACE_MASKD, "got a problem to work with");
                Trace.trace(TRACE_MASKD, aProblem.formatProblemString(aProblem.getProblemString()));
            }
            PanelBean sib = null;
            try {
                ProblemBeanFactory cbf = (ProblemBeanFactory)ServiceInterfaces.getFactory(aProblem, "BeanFactory");
                sib = cbf.getServiceInformationBeanCE(aProblem, objectId, system, 3);
            }
            catch (ServiceInterfacesException e) {
                Trace.trace(TRACE_MASKT, "can't resolve bean factory!");
                Trace.trace(TRACE_MASKF, e);
                throw new HException(e);
            }
            Trace.trace(TRACE_MASKD, "<--getServiceInformationBeanCE");
            return sib;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Got PM Exception =" + e);
            Trace.trace(TRACE_MASKD, "<--getServiceInformationBeanCE");
            e.printStackTrace();
            return null;
        }
    }

    LocalizableText[] getLtArray(List list) {
        int length = list.size();
        LocalizableText[] ltArray = new LocalizableText[length];
        int i = 0;
        while (i < length) {
            ltArray[i] = (LocalizableText)list.get(i);
            ++i;
        }
        return ltArray;
    }

    public String toString() {
        return "HMC Service data provider";
    }
}

